package gov.va.med.mhv.rxrefill.converter;

import gov.va.med.domain.persistence.jdbc.helper.EndpointEntry;
import gov.va.med.mhv.rxrefill.data.model.DestinationFunction;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class DestinationFunctionConverter implements Converter<DestinationFunction, EndpointEntry> {

	@Override
	public EndpointEntry convert(DestinationFunction source) {
		EndpointEntry target = new EndpointEntry();
		
		target.setDestinationId(source.getDestinationFunctionKey().getDestinationId());
		target.setEndpointId(source.getDestinationFunctionKey().getEndpointId());
		target.setFunctionId(source.getDestinationFunctionKey().getFunctionId());
		target.setProtocolType(source.getProtocolType());
		target.setEncodingType(source.getEncodingType());
		target.setTransceiver(source.getTransceiver());
		target.setFunctionName(source.getFunctionName());
		target.setEncoder(source.getEncoder());
		target.setDecoder(source.getDecoder());
		target.setAsyncDecoder(source.getAsyncDecoder());
		target.setHandler(source.getAsyncHandler());
		target.setAaEncoder(source.getAaEncoder());
		target.setCategory(source.getCategory());
		
		return target;
	}

}
